{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 * Data inici: 01/10/04
 * Ultim dia:  12/10/04
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitCalculsMatematics;

{************************************************}
interface
{************************************************}

uses UnitDades;

{*******************************************************}
//Clculs matemtics genrics
function PeriodeAFrequencia(m:single):single;
function FrequenciaAPeriode(m:single):integer;
Procedure NormalitzarSumaQuoeficients(NombreDeQuoeficients:integer;SumaPerNormalitzar:single; var Quoeficients:NumerosPerCalcular); //EscalaPerNormalitzar=200
Procedure NormalitzarQuoeficientsPerMaxim(NombreDeQuoeficients:integer;MaximPerNormalitzar:single; var Quoeficients:NumerosPerCalcular);
Procedure CalcularElLogaritmeAlsQuoeficients(NombreDeQuoeficients:integer;var Quoeficients:NumerosPerCalcular);
Procedure CalcularQuoeficientsXAEscalaMel(NombreDeQuoeficients:integer;var Quoeficients:NumerosPerCalcular);
function Mel(frequencia:integer):integer;
Procedure CalcularDecibelsAlsQuoeficients(NombreDeQuoeficients:integer;var Quoeficients:NumerosPerCalcular);
Procedure CalcularAdaptacioALOida(NombreDeQuoeficients:integer;PosarA0ElPrimer:Boolean;var QuoeficientsX,QuoeficientsY:NumerosPerCalcular);
Function CalcularEnergiaALInterval(NombreDeQuoeficients:integer;var Quoeficients:NumerosPerCalcular):single;
Function CalcularRelacioEnergiesALInterval(NombreDeQuoeficients:integer;var QuoeficientsX, QuoeficientsY:NumerosPerCalcular):single;

{*******************************************************}
Procedure CalcularFFT(P,H,O,D,NS,NM,RD:Boolean;S,M:single;N:integer;var Dades:NumerosPerCalcular;var NE:integer;var InterX:single;var FFTX,FFTY,FFTCos,FFTSin:NumerosPerCalcular);

{*******************************************************}
Procedure CalcularPreenfasis(var NumerosPerCalcularFFT:NumerosPerCalcular;GrandariaNumerosBufferFFT:integer);
Procedure CalcularFinestraDeHamming(var NumerosPerCalcularFFT:NumerosPerCalcular;GrandariaNumerosBufferFFT:integer);

{*******************************************************}
procedure CalcularQuoeficientsFFTY({Entrada}var NumerosPerCalcularFFT:NumerosPerCalcular;GrandariaNumerosBufferFFT:integer;{Sortida}var NombreDeQuoeficientsFFT:integer;var IntervalXQuoeficientsFFT:single;var QuoeficientsFFTX,QuoeficientsFFTY,QuoeficientsFFTCosinus,QuoeficientsFFTSinus:NumerosPerCalcular);
procedure CalcularInversaFFT({Entrada}var QuoeficientsFFTCosinus,QuoeficientsFFTSinus:NumerosPerCalcular;GrandariaNumerosBufferFFT:integer;{Sortida}var NumerosTransformatsInversaFFT:NumerosPerCalcular);

{*******************************************************}
Procedure CalcularQuoeficientsFourierDiscrets({Entrada}var NumerosPerCalcularQuoeficientsFourierDiscrets:NumerosPerCalcular;GrandariaNumerosPerCalcularQuoeficientsFourierDiscrets:integer;{Sortida}var NombreDeQuoeficientsFourierDiscrets:integer;var QuoeficientsFourierDiscretsX,QuoeficientsFourierDiscretsY:NumerosPerCalcular);

{*******************************************************}
Procedure CalcularQuoeficientsCepstrumPerFFT({Entrada}GrandariaNumerosBufferQuoeficientsCepstrumPerFFT:integer;NumerosPerCalcularQuoeficientsCepstrumPerFFT:NumerosPerCalcular;{Sortida}var NombreDeQuoeficientsCepstrumPerFFT:integer;var QuoeficientsCepstrumPerFFTX,QuoeficientsCepstrumPerFFTY,QuoeficientsCepstrumPerFFTCosinus,QuoeficientsCepstrumPerFFTSinus:NumerosPerCalcular);

{************************************************}
Procedure CalcularQuoeficientsBankFiltres({Entrada}GrandariaNumerosBufferQuoeficientsBankFiltres:integer;NumerosPerCalcularQuoeficientsBankFiltresX,NumerosPerCalcularQuoeficientsBankFiltresY:NumerosPerCalcular;EscalaMel:Boolean;{Sortida}var NombreDeQuoeficientsBankFiltres:integer;var QuoeficientsBankFiltresX,QuoeficientsBankFiltresY:NumerosPerCalcular);

{************************************************}
implementation
{************************************************}

function PeriodeAFrequencia(m:single):single;
begin
  if m>0 then PeriodeAFrequencia:=FrequenciaDeMostreigEntradaSo/m else PeriodeAFrequencia:=0;
end;

function FrequenciaAPeriode(m:single):integer;
begin
  if m>0 then FrequenciaAPeriode:=Round(FrequenciaDeMostreigEntradaSo/m) else FrequenciaAPeriode:=0;
end;

Procedure NormalitzarSumaQuoeficients(NombreDeQuoeficients:integer;SumaPerNormalitzar:single; var Quoeficients:NumerosPerCalcular); //EscalaPerNormalitzar=200
var
  Suma:single;
  i:integer;
begin
  Suma:=0;
  for i:=1 to NombreDeQuoeficients do Suma:=Quoeficients[i]+Suma;
  if Suma>0 then begin
    Suma:=SumaPerNormalitzar/Suma;
    for i:=1 to NombreDeQuoeficients do Quoeficients[i]:=Quoeficients[i]*Suma;
  end;
end;

Procedure NormalitzarQuoeficientsPerMaxim(NombreDeQuoeficients:integer;MaximPerNormalitzar:single; var Quoeficients:NumerosPerCalcular);
var
  Maxim:single;
  Comodi:Single;
  i:integer;
begin
  Maxim:=0;
  for i:=1 to NombreDeQuoeficients do if Quoeficients[i]>Maxim then Maxim:=Quoeficients[i];
  if Maxim>0 then begin
    Comodi:=MaximPerNormalitzar/Maxim;
    for i:=1 to NombreDeQuoeficients do Quoeficients[i]:=Quoeficients[i]*Comodi;
  end;
end;

Procedure CalcularElLogaritmeAlsQuoeficients(NombreDeQuoeficients:integer;var Quoeficients:NumerosPerCalcular);
var
  i:integer;
  VintPartitPerLogaritmeNeperiaDe10:single;
begin
  VintPartitPerLogaritmeNeperiaDe10:=20/ln(10);
  //for i:=1 to NombreDeQuoeficients do if Quoeficients[i]>1 then Quoeficients[i]:=20*ln(Quoeficients[i])/ln(10) else Quoeficients[i]:=0
  for i:=1 to NombreDeQuoeficients do if Quoeficients[i]>1 then Quoeficients[i]:=ln(Quoeficients[i])*VintPartitPerLogaritmeNeperiaDe10 else Quoeficients[i]:=0
end;

Procedure CalcularQuoeficientsXAEscalaMel(NombreDeQuoeficients:integer;var Quoeficients:NumerosPerCalcular);
var
  i:integer;
begin
  //Escala Mel  m = 1127 ln (1 + f / 700)
  For i:=1 to NombreDeQuoeficients do Quoeficients[i]:=1127*ln(1+Quoeficients[i]/700);
end;

function Mel(frequencia:integer):integer;
begin
  Mel:=Round(1127*ln(1+frequencia/700));
end;

Procedure CalcularDecibelsAlsQuoeficients(NombreDeQuoeficients:integer;var Quoeficients:NumerosPerCalcular);
var
  i:integer;
begin
  for i:=0 to NombreDeQuoeficients do begin
    try
      if Quoeficients[i]>0 then Quoeficients[i]:= 10*ln(sqr(Quoeficients[i])/16384)/ln(10)+120;
    except
      Quoeficients[i]:=0;
    end;
  end;
end;

Procedure CalcularAdaptacioALOida(NombreDeQuoeficients:integer;PosarA0ElPrimer:Boolean;var QuoeficientsX,QuoeficientsY:NumerosPerCalcular);
var
  i:integer;
begin
  if PosarA0ElPrimer then begin
    QuoeficientsY[1]:=0;
    for i:=2 to NombreDeQuoeficients do
     if QuoeficientsY[i]>0 then QuoeficientsY[i]:=QuoeficientsY[i]/(79.1874212*exp(-0.800147*ln(QuoeficientsX[i])));
  end else begin
    for i:=1 to NombreDeQuoeficients do
     if QuoeficientsY[i]>0 then QuoeficientsY[i]:=QuoeficientsY[i]/(79.1874212*exp(-0.800147*ln(QuoeficientsX[i])));
  end;
end;

Function CalcularEnergiaALInterval(NombreDeQuoeficients:integer;var Quoeficients:NumerosPerCalcular):single;
var
  i:integer;
  Energia:single;
begin
  Energia:=0;
  for i:=1 to NombreDeQuoeficients do Energia:=Energia+Quoeficients[i]*Quoeficients[i];
  CalcularEnergiaALInterval:=Energia/NombreDeQuoeficients;
end;

Function CalcularRelacioEnergiesALInterval(NombreDeQuoeficients:integer;var QuoeficientsX, QuoeficientsY:NumerosPerCalcular):single;
Const
  FrequenciaSonors = 800;
  FrequenciaSords = 3000;
var
  i:integer;
  Energia1,Energia2:single;
begin
  Energia1:=0;
  Energia2:=0;
  for i:=1 to NombreDeQuoeficients do begin
    if QuoeficientsX[i]<=FrequenciaSonors then begin
      Energia1:=Energia1+QuoeficientsY[i]*QuoeficientsY[i];
      //Energia1:=Energia1+QuoeficientsY[i];
    end else if QuoeficientsX[i]>FrequenciaSords then begin
      Energia2:=Energia2+QuoeficientsY[i]*QuoeficientsY[i];
      //Energia2:=Energia2+QuoeficientsY[i];
    end;
  end;
  if Energia1+Energia2>0 then CalcularRelacioEnergiesALInterval:=Energia1/(Energia1+Energia2)*100 else CalcularRelacioEnergiesALInterval:=0;
end;

{*******************************************************}
Procedure CalcularFFT(P,H,O,D,NS,NM,RD:Boolean;S,M:single;N:integer;var Dades:NumerosPerCalcular;var NE:integer;var InterX:single;var FFTX,FFTY,FFTCos,FFTSin:NumerosPerCalcular);
var
  MinimYDecibels:single;
begin
  //P Preenfasis
  //H Hamming
  //O Oida
  //D Escala Y Decibels
  //NS Normalitzar per Suma
  //NM Normalitzar per Mxim
  //RD Realat Escala Y Decibels
  //S Suma:=200;
  //M Max:=255; o 5
  //NE NumerosEspectre
  if P then CalcularPreenfasis(Dades,N);
  if H then CalcularFinestraDeHamming(Dades,N);
  CalcularQuoeficientsFFTY(Dades,N,NE,InterX,FFTX,FFTY,FFTCos,FFTSin);
  if O then CalcularAdaptacioALOida(NE,true,FFTX,FFTY);
  if D then CalcularDecibelsAlsQuoeficients(NE,FFTY);
  if NS then NormalitzarSumaQuoeficients(NE,S,FFTY);
  if NM then begin
    NormalitzarQuoeficientsPerMaxim(NE,M,FFTY);
    if RD and D then begin
      MinimYDecibels:=255;
      for n:=1 to NE do if FFTY[n]<MinimYDecibels then MinimYDecibels:=FFTY[n];
      for n:=1 to NE do FFTY[n]:=FFTY[n]-MinimYDecibels;
      NormalitzarQuoeficientsPerMaxim(NE,M,FFTY);
    end;
  end;
end;

{*******************************************************}
Procedure CalcularPreenfasis(var NumerosPerCalcularFFT:NumerosPerCalcular;GrandariaNumerosBufferFFT:integer);
var
  Comodi1,Comodi2:Single;
  Preemphasis:single;
  i:integer;
begin
  Comodi2:=0.;
  Preemphasis:=0.95;
  for i:=1 to GrandariaNumerosBufferFFT do begin
    Comodi1:= NumerosPerCalcularFFT[i];
    NumerosPerCalcularFFT[i]:= NumerosPerCalcularFFT[i]-Preemphasis*Comodi2;
    Comodi2:=Comodi1;
  end;
end;

Procedure CalcularFinestraDeHamming(var NumerosPerCalcularFFT:NumerosPerCalcular;GrandariaNumerosBufferFFT:integer);
var
  DosPiPartitPerN:Single;
  TamanyBufferPartitPer2:integer;
  i:integer;
begin
  DosPiPartitPerN:=2*3.1416/GrandariaNumerosBufferFFT;
  TamanyBufferPartitPer2:=GrandariaNumerosBufferFFT div 2;
  for i:=1 to GrandariaNumerosBufferFFT do NumerosPerCalcularFFT[i]:=NumerosPerCalcularFFT[i]*(0.54+0.46*cos(DosPiPartitPerN*(i-TamanyBufferPartitPer2)));
end;

{*******************************************************}
procedure CalcularQuoeficientsFFTY({Entrada}var NumerosPerCalcularFFT:NumerosPerCalcular;GrandariaNumerosBufferFFT:integer;{Sortida}var NombreDeQuoeficientsFFT:integer;var IntervalXQuoeficientsFFT:single;var QuoeficientsFFTX,QuoeficientsFFTY,QuoeficientsFFTCosinus,QuoeficientsFFTSinus:NumerosPerCalcular);
var
  m,irem,l,le,le1,i,j,k,ip:integer;
  ur,ui,wr,wi,tr,ti,temp:Single;
  npt:LongInt;
  Comodi:Single;
  DR,DI: NumerosPerCalcular;
begin
  for i:=1 to GrandariaNumerosBufferFFT do begin
    DR[i]:= NumerosPerCalcularFFT[i];
    DI[i]:= 0.;
  end;
  Comodi:=0.5;
  npt:=GrandariaNumerosBufferFFT;
  j:=1;
  for i:=1 to npt-1 do begin
    if i<j then begin
      tr:=DR[j];
      ti:=DI[j];
      DR[j]:=DR[i];
      DI[j]:=DI[i];
      DR[i]:=tr;
      DI[i]:=ti;
      k:=round(npt*Comodi);
      while k<j do begin
        j:=j-k;
        k:=round(k*Comodi);
      end;
    end else begin
      k:=round(npt*Comodi);
      while k<j do begin
        j:=j-k;
        k:=round(k*Comodi);
      end;
    end;
    j:=j+k;
  end;
  m:=0;
  irem:=npt;
  while irem>1 do begin
    irem:=round(irem*Comodi);
    m:=m+1;
  end;
  for l:=1 to m do begin
    le:=round(exp(l*ln(2)));
    le1:=round(le*Comodi);
    ur:=1.0;
    ui:=0;
    wr:=cos(pi/le1);
    wi:=sin(pi/le1);
    for j:=1 to le1 do begin
      i:=j;
      while i<=npt do begin
        ip:=i+le1;
        tr:=DR[ip]*ur-DI[ip]*ui;
        ti:=DI[ip]*ur+DR[ip]*ui;
        DR[ip]:=DR[i]-tr;
        DI[ip]:=DI[i]-ti;
        DR[i]:=DR[i]+tr;
        DI[i]:=DI[i]+ti;
        i:=i+le;
      end;
      temp:=ur*wr-ui*wi;
      ui:=ui*wr+ur*wi;
      ur:=temp;
    end;
  end;
  NombreDeQuoeficientsFFT:=Round(GrandariaNumerosBufferFFT/2);
  Comodi:=1/NombreDeQuoeficientsFFT;
  IntervalXQuoeficientsFFT:=FrequenciaDeMostreigEntradaSo/(GrandariaNumerosBufferFFT-1);
  //IntervalXQuoeficientsFFT:=FrequenciaDeMostreigEntradaSo/GrandariaNumerosBufferFFT;
  for i:=1 to GrandariaNumerosBufferFFT do begin
    QuoeficientsFFTX[i]:=(i-1)*IntervalXQuoeficientsFFT;
    QuoeficientsFFTY[i]:=(sqrt(DR[i]*DR[i]+DI[i]*DI[i]))*Comodi;
    QuoeficientsFFTCosinus[i]:=DR[i]*Comodi;
    QuoeficientsFFTSinus[i]:=DI[i]*Comodi;
  end;
end;

procedure CalcularInversaFFT({Entrada}var QuoeficientsFFTCosinus,QuoeficientsFFTSinus:NumerosPerCalcular;GrandariaNumerosBufferFFT:integer;{Sortida}var NumerosTransformatsInversaFFT:NumerosPerCalcular);
var
  m,irem,l,le,le1,i,j,k,ip:integer;
  ur,ui,wr,wi,tr,ti,temp:Single;
  npt:LongInt;
  comodi1:Single;
  DR,DI:NumerosPerCalcular;
begin
  npt:=GrandariaNumerosBufferFFT;
  for i:=1 to npt do begin
    DR[i]:=QuoeficientsFFTCosinus[i];
    DI[i]:=QuoeficientsFFTSinus[i];
  end;
  for i:=round(npt/2) to npt do begin
    DR[i]:=0;
    DI[i]:=0;
  end;
  //Aqu s posa el filtre que es vulgui fer Per exemple el que hi ha
  //Per exemple el que hi ha de mostra s treure les freqncies superiors a 1000
  {}
  //Comodi1:=Mostras/npt;
  Comodi1:=FrequenciaDeMostreigEntradaSo/npt;
  for i:=1 to npt do begin
    if ((i-1)*Comodi1>1000) or ((i-1)*Comodi1<0) then begin
      DR[i]:=0;
      DI[i]:=0;
    end;
  end;
  {}
  j:=1;
  comodi1:=0.5;
  for i:=1 to npt-1 do begin
    if i<j then begin
      tr:=DR[j];
      ti:=DI[j];
      DR[j]:=DR[i];
      DI[j]:=DI[i];
      DR[i]:=tr;
      DI[i]:=ti;
      k:=round(npt*comodi1);
      while k<j do begin
        j:=j-k;
        k:=round(k*comodi1);
      end;
    end else begin
      k:=round(npt*comodi1);
      while k<j do begin
        j:=j-k;
        k:=round(k*comodi1);
      end;
    end;
    j:=j+k;
  end;
  m:=0;
  irem:=npt;
  while irem>1 do begin
    irem:=round(irem*comodi1);
    m:=m+1;
  end;
  for l:=1 to m do begin
    le:=round(exp(l*ln(2)));
    le1:=round(le*comodi1);
    ur:=1.0;
    ui:=0;
    wr:=cos(pi/le1);
    wi:=sin(pi/le1);
    for j:=1 to le1 do begin
      i:=j;
      while i<=npt do begin
        ip:=i+le1;
        tr:=DR[ip]*ur-DI[ip]*ui;
        ti:=DI[ip]*ur+DR[ip]*ui;
        DR[ip]:=DR[i]-tr;
        DI[ip]:=DI[i]-ti;
        DR[i]:=DR[i]+tr;
        DI[i]:=DI[i]+ti;
        i:=i+le;
      end;
      temp:=ur*wr-ui*wi;
      ui:=ui*wr+ur*wi;
      ur:=temp;
    end;
  end;
  for i:=1 to GrandariaNumerosBufferFFT do NumerosTransformatsInversaFFT[i]:=round(DR[i]*2);
end;

{*******************************************************}
Procedure CalcularQuoeficientsFourierDiscrets({Entrada}var NumerosPerCalcularQuoeficientsFourierDiscrets:NumerosPerCalcular;GrandariaNumerosPerCalcularQuoeficientsFourierDiscrets:integer;{Sortida}var NombreDeQuoeficientsFourierDiscrets:integer;var QuoeficientsFourierDiscretsX,QuoeficientsFourierDiscretsY:NumerosPerCalcular);
var
  n,i:integer;
  f,dpipT,dpipTi:real;
  T:longint;
  R1,R2:real;
  PeriodeDeLOna:Integer;
begin
  PeriodeDeLOna:=GrandariaNumerosPerCalcularQuoeficientsFourierDiscrets-1;
  //PeriodeDeLOna:=GrandariaNumerosPerCalcularQuoeficientsFourierDiscrets;
  if PeriodeDeLOna=0 then exit;
  T:=PeriodeDeLOna;
  dpipT:=2*pi/T;
  f:=FrequenciaDeMostreigEntradaSo/T;
  NombreDeQuoeficientsFourierDiscrets:=Round(5500/f);
  for i:=1 to NombreDeQuoeficientsFourierDiscrets do begin
    QuoeficientsFourierDiscretsX[i]:=f*i;
    QuoeficientsFourierDiscretsY[i]:=0;
    dpipTi:=dpipT*i;
    R1:=0;
    for n:=1 to PeriodeDeLOna-1 do R1:=R1+NumerosPerCalcularQuoeficientsFourierDiscrets[n]*sin(dpipTi*n);
    R1:=R1*2/T;
    R2:=0;
    for n:=0 to PeriodeDeLOna do R2:=R2+NumerosPerCalcularQuoeficientsFourierDiscrets[n]*cos(dpipTi*n);
    R2:=R2*2/T;
    QuoeficientsFourierDiscretsY[i]:=sqrt(R1*R1+R2*R2);
  end;
end;

{*******************************************************}
Procedure CalcularQuoeficientsCepstrumPerFFT({Entrada}GrandariaNumerosBufferQuoeficientsCepstrumPerFFT:integer;NumerosPerCalcularQuoeficientsCepstrumPerFFT:NumerosPerCalcular;{Sortida}var NombreDeQuoeficientsCepstrumPerFFT:integer;var QuoeficientsCepstrumPerFFTX,QuoeficientsCepstrumPerFFTY,QuoeficientsCepstrumPerFFTCosinus,QuoeficientsCepstrumPerFFTSinus:NumerosPerCalcular);
var
  i:integer;
  IntervalXQuoeficientsFFT:single;
  QuoeficientsFFTX,QuoeficientsFFTY,QuoeficientsFFTCosinus,QuoeficientsFFTSinus:NumerosPerCalcular;
begin
  CalcularQuoeficientsFFTY(NumerosPerCalcularQuoeficientsCepstrumPerFFT,GrandariaNumerosBufferQuoeficientsCepstrumPerFFT,NombreDeQuoeficientsCepstrumPerFFT,IntervalXQuoeficientsFFT,QuoeficientsFFTX,QuoeficientsFFTY,QuoeficientsFFTCosinus,QuoeficientsFFTSinus);
  for i:=1 to NombreDeQuoeficientsCepstrumPerFFT do begin
    //QuoeficientsCepstrumPerFFTX[i]:=i;
    QuoeficientsCepstrumPerFFTX[i]:=i-1;
    QuoeficientsCepstrumPerFFTY[i]:=QuoeficientsFFTY[i]*NombreDeQuoeficientsCepstrumPerFFT;
    QuoeficientsCepstrumPerFFTCosinus[i]:=QuoeficientsFFTCosinus[i]*NombreDeQuoeficientsCepstrumPerFFT;
    QuoeficientsCepstrumPerFFTSinus[i]:=QuoeficientsFFTSinus[i]*NombreDeQuoeficientsCepstrumPerFFT;
  end;
end;

Procedure CalcularQuoeficientsBankFiltres({Entrada}GrandariaNumerosBufferQuoeficientsBankFiltres:integer;NumerosPerCalcularQuoeficientsBankFiltresX,NumerosPerCalcularQuoeficientsBankFiltresY:NumerosPerCalcular;EscalaMel:Boolean;{Sortida}var NombreDeQuoeficientsBankFiltres:integer;var QuoeficientsBankFiltresX,QuoeficientsBankFiltresY:NumerosPerCalcular);
var
  n,i:integer;
  MigEscala,DeltaEscala:single;
  RealMel{,ImaginariMel,SumaEscalaMel}:single;
begin
  MigEscala:=100;
  DeltaEscala:=MigEscala;
  //Amb l'interval ms gran sembla que millor
  //DeltaEscala:=200;
  n:=0;
  while MigEscala+DeltaEscala<NumerosPerCalcularQuoeficientsBankFiltresX[GrandariaNumerosBufferQuoeficientsBankFiltres] do begin
    RealMel:=0;
    //ImaginariMel:=0;
    for i:=1 to GrandariaNumerosBufferQuoeficientsBankFiltres do begin
      if (NumerosPerCalcularQuoeficientsBankFiltresX[i]>MigEscala-DeltaEscala) and (NumerosPerCalcularQuoeficientsBankFiltresX[i]<MigEscala+DeltaEscala) and (i<=GrandariaNumerosBufferQuoeficientsBankFiltres) then begin
        {
        //amb els nmeros complexos sembla que no pita gaire
        RealMel:=RealMel+DR^[i]*(1-abs(MigEscala-XCoeFou^[i])/DeltaEscala);
        ImaginariMel:=ImaginariMel+DI^[i]*(1-abs(MigEscala-XCoeFou^[i])/DeltaEscala);
        }
        //SSumant directament els quoeficients sembla que pita millor. 02/09/03. Crec que el llibre ho fa aix
        RealMel:=RealMel+NumerosPerCalcularQuoeficientsBankFiltresY[i]*(1-abs(MigEscala-NumerosPerCalcularQuoeficientsBankFiltresX[i])/DeltaEscala);
      end;
    end;
    inc(n);
    QuoeficientsBankFiltresX[n]:=MigEscala;
    //QuoeficientsEscalaMel[2,n]:=sqrt(sqr(RealMel)+sqr(ImaginariMel))/2;
    QuoeficientsBankFiltresY[n]:=RealMel;
    if (MigEscala>1000) and EscalaMel then DeltaEscala:=DeltaEscala*1.2;
    //sense l'escala de mel (o sigui lineal) sembla millor
    MigEscala:=MigEscala+DeltaEscala;
    //MigEscala:=MigEscala+100;
  end;
  NombreDeQuoeficientsBankFiltres:=n;
end;

{*******************************************************}
begin
end.
